/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.algorithms;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.util.AbstractComparableIterator;
import cz.insophy.inplan.util.JointIterator;
import cz.insophy.inplan.util.SimpleComparableIterator;
import java.util.Set;

public class OfflineMergeIterator
extends JointIterator<OfflineActivity> {
    private OfflineActivity reserve;

    public OfflineMergeIterator(Set<AbstractComparableIterator<OfflineActivity>> iters) {
        super(OfflineMergeIterator.transformIterator(iters));
    }

    private static Set<AbstractComparableIterator<OfflineActivity>> transformIterator(Set<AbstractComparableIterator<OfflineActivity>> iters) {
        return Sets.newHashSet(Collections2.transform(iters, new Function<AbstractComparableIterator<OfflineActivity>, AbstractComparableIterator<OfflineActivity>>(){

            @Override
            public AbstractComparableIterator<OfflineActivity> apply(AbstractComparableIterator<OfflineActivity> input) {
                return new SimpleComparableIterator<OfflineActivity>(input);
            }
        }));
    }

    @Override
    protected void prepareNext() {
        OfflineActivity next = null;
        if (this.reserve != null) {
            next = this.reserve;
            this.reserve = null;
        }
        super.prepareNext();
        while (super.hasNext()) {
            OfflineActivity nextRaw = (OfflineActivity)super.getNext();
            if (next == null) {
                next = nextRaw;
            } else if (nextRaw.getStart() <= next.getEnd()) {
                next.setEnd(nextRaw.getEnd());
            } else {
                this.reserve = nextRaw;
                break;
            }
            super.prepareNext();
        }
        this.setNext(next);
    }
}

